package com.appodeal.consent

import android.app.Activity

/**
 * Data class representing the parameters for a consent update request in the Appodeal Consent Manager.
 * Use this class to encapsulate the necessary information for updating consent preferences.
 *
 * @param activity [Activity] The activity in which the consent update is requested.
 * @param key The key associated with the user for whom the consent is being updated.
 * @param tagForUnderAgeOfConsent Optional. Indicates whether the user is tagged for under the age of consent.
 *                                Set to true if the user is under the age of consent, otherwise set to false or null.
 * @param sdk Optional. The identifier for the SDK making the consent update request.
 * @param sdkVersion Optional. The version of the SDK making the consent update request.
 */
open class ConsentUpdateRequestParameters internal constructor(
    val key: String,
    val tagForUnderAgeOfConsent: Boolean? = null,
    val sdk: String? = null,
    val sdkVersion: String? = null,
) {
    private var _activity: Activity? = null

    val requiredActivity: Activity
        get() = requireNotNull(_activity) { "Activity is null" }

    @JvmOverloads
    constructor(
        activity: Activity,
        key: String,
        tagForUnderAgeOfConsent: Boolean? = null,
        sdk: String? = null,
        sdkVersion: String? = null,
    ) : this(key, tagForUnderAgeOfConsent, sdk, sdkVersion) {
        this._activity = activity
    }
}
