package com.appodeal.consent

// Enum class representing different CMP (Consent Management Platform) types
enum class CmpType(val typeName: String) {

    // UMP (User Messaging Platform) - The SDK will use Google CMP (Consent Management Platform)
    Ump("UMP"),

    // None - Indicates that no specific CMP is selected and Appodeal CMP will be used
    None("NONE");

    // Companion object with a method to get the CMPType based on a given type string
    companion object {
        /**
         * Gets the CMPType based on the provided type string.
         *
         * @param type The type string to match against CMPType values.
         * @return The corresponding CMPType, or None if no match is found.
         */
        fun get(type: String?) = values().firstOrNull { it.typeName == type } ?: None
    }
}
