package com.appodeal.consent

/**
 * Interface for handling updates to consent information.
 * Implement this interface to receive callbacks when consent information is updated or fails to update.
 */
interface ConsentInfoUpdateCallback {

    /**
     * Called when consent information is successfully updated.
     * Implement this method to handle successful updates.
     */
    fun onUpdated()

    /**
     * Called when updating consent information fails.
     * Implement this method to handle failures and receive information about the error.
     *
     * @param error The specific error encountered during the consent information update.
     * Possible values are defined in the [ConsentManagerError] enum.
     */
    fun onFailed(error: ConsentManagerError)
}
