package com.appodeal.ads.nativead

import android.content.Context
import android.util.AttributeSet
import android.view.ViewGroup.LayoutParams.WRAP_CONTENT
import android.widget.RatingBar
import android.widget.RelativeLayout
import android.widget.RelativeLayout.BELOW
import android.widget.RelativeLayout.END_OF
import com.appodeal.ads.utils.Log.log
import com.appodeal.ads.utils.exception_handler.AppodealException

/**
 * App wall template for native ad
 */
class NativeAdViewAppWall @JvmOverloads constructor(
    context: Context,
    attrs: AttributeSet? = null,
    defStyleAttr: Int = 0,
) : NativeAdViewTemplate(context, attrs, defStyleAttr, iconViewSize = 70) {

    override fun initViews(relativeLayout: RelativeLayout) {
        super.initViews(relativeLayout)
        val iconViewId = iconView?.id
        val descriptionViewId = descriptionView?.id
        val callToActionViewId = callToActionView?.id

        if (iconViewId == null || descriptionViewId == null || callToActionViewId == null) {
            log(
                AppodealException(
                    "NativeAdViewAppWall: IconView or DescriptionView or CallToActionView can not be null"
                )
            )
            return
        }

        RatingBar(context, null, android.R.attr.ratingBarStyleSmall).apply {
            layoutParams = RelativeLayout.LayoutParams(WRAP_CONTENT, WRAP_CONTENT).apply {
                addRule(END_OF, iconViewId)
                addRule(BELOW, descriptionViewId)
                setMargins(DEFAULT_INDENT, DEFAULT_INDENT, 0, 0)
            }
            numStars = 5
            max = 5
            id = generateViewId()
        }.also { view ->
            ratingView = view
            relativeLayout.addView(view)
        }
    }
}
