package com.appodeal.ads.nativead

import android.content.Context
import android.util.AttributeSet
import android.widget.RatingBar
import android.widget.RelativeLayout
import android.widget.RelativeLayout.BELOW
import android.widget.RelativeLayout.END_OF
import android.widget.RelativeLayout.LayoutParams.MATCH_PARENT
import android.widget.RelativeLayout.LayoutParams.WRAP_CONTENT
import com.appodeal.ads.utils.Log.log
import com.appodeal.ads.utils.exception_handler.AppodealException

/**
 * Content stream template for native ad
 */
class NativeAdViewContentStream @JvmOverloads constructor(
    context: Context,
    attrs: AttributeSet? = null,
    defStyleAttr: Int = 0,
) : NativeAdViewTemplate(context, attrs, defStyleAttr, iconViewSize = 90) {

    override fun initViews(relativeLayout: RelativeLayout) {
        super.initViews(relativeLayout)
        val iconViewId = iconView?.id
        val descriptionViewId = descriptionView?.id

        if (iconViewId == null || descriptionViewId == null) {
            log(AppodealException("NativeAdViewContentStream: IconView/descriptionView can not be null"))
            return
        }

        RatingBar(context, null, android.R.attr.ratingBarStyleSmall).apply {
            layoutParams = RelativeLayout.LayoutParams(WRAP_CONTENT, WRAP_CONTENT).apply {
                addRule(END_OF, iconViewId)
                addRule(BELOW, descriptionViewId)
            }
            numStars = 5
            max = 5
            id = generateViewId()
        }.also { view ->
            ratingView = view
            relativeLayout.addView(view)
        }

        NativeMediaView(context).apply {
            layoutParams = RelativeLayout.LayoutParams(MATCH_PARENT, WRAP_CONTENT).apply {
                setMargins(0, DEFAULT_INDENT, 0, 0)
                addRule(BELOW, iconViewId)
            }
            id = generateViewId()
        }.also { view ->
            mediaView = view
            relativeLayout.addView(view)
        }
    }
}
