package com.appodeal.ads.nativead

import android.content.Context
import android.util.AttributeSet
import android.view.Gravity
import android.view.View
import android.widget.FrameLayout
import kotlin.math.abs
import kotlin.math.min

/**
 * Used in native ads to show image content like icon
 */
class NativeIconView @JvmOverloads constructor(
    context: Context,
    attrs: AttributeSet? = null,
    defStyleAttr: Int = 0,
    defStyleRes: Int = 0,
) : FrameLayout(context, attrs, defStyleAttr, defStyleRes) {

    override fun onMeasure(widthMeasureSpec: Int, heightMeasureSpec: Int) {
        val widthMode = MeasureSpec.getMode(widthMeasureSpec)
        val heightMode = MeasureSpec.getMode(heightMeasureSpec)
        val measWidth = MeasureSpec.getSize(widthMeasureSpec)
        val measHeight = MeasureSpec.getSize(heightMeasureSpec)
        val curWidth = measuredWidth
        val curHeight = measuredHeight
        var finalWidth = when (widthMode) {
            MeasureSpec.EXACTLY -> measWidth
            MeasureSpec.AT_MOST -> min(measWidth, curWidth)
            else -> curWidth
        }

        var finalHeight = (finalWidth)

        if (heightMode == MeasureSpec.EXACTLY && measHeight < finalHeight) {
            finalHeight = measHeight
            finalWidth = (finalHeight)
        }
        if (abs(finalHeight - curHeight) >= 2 || abs(finalWidth - curWidth) >= 2) {
            layoutParams.width = finalWidth
            layoutParams.height = finalHeight
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec)
    }

    internal fun setIconView(iconView: View) {
        removeAllViews()
        addView(
            iconView,
            LayoutParams(
                LayoutParams.MATCH_PARENT,
                LayoutParams.MATCH_PARENT,
                Gravity.CENTER
            )
        )
    }
}
