package com.appodeal.ads.nativead

import android.content.Context
import android.util.AttributeSet
import android.view.Gravity
import android.view.View
import android.widget.FrameLayout
import kotlin.math.abs
import kotlin.math.min

/**
 * Used in native ads to show static or video content
 */
class NativeMediaView @JvmOverloads constructor(
    context: Context,
    attrs: AttributeSet? = null,
    defStyleAttr: Int = 0,
    defStyleRes: Int = 0
) : FrameLayout(context, attrs, defStyleAttr, defStyleRes) {

    override fun onMeasure(widthMeasureSpec: Int, heightMeasureSpec: Int) {
        val widthMode = MeasureSpec.getMode(widthMeasureSpec)
        val heightMode = MeasureSpec.getMode(heightMeasureSpec)
        val measWidth = MeasureSpec.getSize(widthMeasureSpec)
        val measHeight = MeasureSpec.getSize(heightMeasureSpec)
        val curWidth = measuredWidth
        val curHeight = measuredHeight
        var finalWidth = when (widthMode) {
            MeasureSpec.EXACTLY -> measWidth
            MeasureSpec.AT_MOST -> min(measWidth, curWidth)
            else -> curWidth
        }

        var finalHeight = (ASPECT_MULTIPLIER_WIDTH_TO_HEIGHT * finalWidth).toInt()

        if (heightMode == MeasureSpec.EXACTLY && measHeight < finalHeight) {
            finalHeight = measHeight
            finalWidth = (ASPECT_MULTIPLIER_HEIGHT_TO_WIDTH * finalHeight).toInt()
        }
        if (abs(finalHeight - curHeight) >= 2 ||
            abs(finalWidth - curWidth) >= 2
        ) {
            layoutParams.width = finalWidth
            layoutParams.height = finalHeight
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec)
    }

    internal fun setMediaView(mediaView: View) {
        removeAllViews()
        addView(
            mediaView,
            LayoutParams(
                LayoutParams.MATCH_PARENT,
                LayoutParams.MATCH_PARENT,
                Gravity.CENTER
            )
        )
    }
}

private const val ASPECT_MULTIPLIER_WIDTH_TO_HEIGHT = 9f / 16
private const val ASPECT_MULTIPLIER_HEIGHT_TO_WIDTH = 16f / 9
