package com.appodeal.ads

/**
 * Callback related to the lifecycle of loading/showing ads
 */
@Deprecated(
    "As of Appodeal SDK version 3.2.0, will be removed in a future release.",
    replaceWith = ReplaceWith("AdRevenueCallbacks")
)
interface AppodealRequestCallbacks {
    /**
     * Called every time the ad waterfall request starts from the first ad unit.
     *
     * @param adType name of the ad type
     */
    fun onWaterfallStart(adType: String)

    /**
     * Called every time the ad waterfall request has finished.
     *
     * @param adType     name of ad type.
     * @param loadedEcpm average price per 1000 impressions from which the ad was loaded.
     * if ad wasn`t load this parameter will 0.
     * @param fill        result of request, if ad was loaded succesfully, this parameter will true, else false.
     */
    fun onWaterfallFinish(
        adType: String,
        loadedEcpm: Double,
        fill: Boolean
    )

    /**
     * Called when the ad block request starts.
     *
     * @param adType        name of ad type.
     * @param networkName   name of ad network.
     * @param adUnitName    unique ad unit name.
     * @param predictedEcpm the average price per 1000 impressions predicted for the requested ad unit.
     */
    fun onRequestStart(
        adType: String,
        networkName: String?,
        adUnitName: String?,
        predictedEcpm: Double
    )

    /**
     * Called when the ad block request finish.
     *
     * @param adType      name of the ad type.
     * @param networkName name of ad network.
     * @param adUnitName  unique ad unit name.
     * @param loadedEcpm  average price per 1000 impressions from which the ad was loaded.
     * *               if ad wasn`t load this parameter will 0.
     * @param fill         result of request, if ad was loaded succesfully, this parameter will true, else false.
     */
    fun onRequestFinish(
        adType: String,
        networkName: String?,
        adUnitName: String?,
        loadedEcpm: Double,
        fill: Boolean
    )

    /**
     * Called every time the ad starts showing.
     *
     * @param adType      name of the ad type.
     * @param networkName name of ad network.
     * @param adUnitName  unique ad unit name.
     * @param loadedEcpm  the average price per 1000 impressions from which the ad was loaded.
     */
    fun onImpression(
        adType: String,
        networkName: String?,
        adUnitName: String?,
        loadedEcpm: Double
    )

    /**
     * Called when there was a click on an ad.
     *
     * @param adType      name of the ad type.
     * @param networkName name of ad network.
     * @param adUnitName  unique ad unit name.
     * @param loadedEcpm  the average price per 1000 impressions from which the ad was loaded.
     */
    fun onClick(
        adType: String,
        networkName: String?,
        adUnitName: String?,
        loadedEcpm: Double
    )
}
