package com.appodeal.ads

import android.content.Context

/**
 * Interface for working with native ads
 */
interface NativeAd {
    /**
     * Get title of native ad
     *
     * @return title string
     */
    val title: String

    /**
     * Get description of native ad
     *
     * @return description string
     */
    val description: String?

    /**
     * Get call to action string of native ad, to show on the button
     *
     * @return call to action string
     */
    val callToAction: String

    /**
     * Get provider name of native ad
     *
     * @return ad provider name
     */
    val adProvider: String?

    /**
     * Get native ad rating
     *
     * @return ad rating
     */
    val rating: Float

    /**
     * Check if native ad is precache
     *
     * @return `true` if ad is precache
     */
    val isPrecache: Boolean

    /**
     * Get predicted ecpm for creative
     */
    val predictedEcpm: Double

    /**
     * Get media assets for icon, main image and video
     *
     * @return media assets [MediaAssets]
     */
    val mediaAssets: MediaAssets

    /**
     * Check if native ad contains video
     *
     * @return `true` if contains
     */
    fun containsVideo(): Boolean

    /**
     * Check if native ad can be shown with placement
     *
     * @param placementName name of placement
     * @return `true` if ad can be shown with this placement, `false` if can't
     */
    fun canShow(context: Context, placementName: String): Boolean

    /**
     * Destroy native ad, unregister from tracking
     */
    fun destroy()
}
