package com.appodeal.ads

/**
 * Native ad's lifecycle interface
 */
interface NativeCallbacks {
    /**
     * Called when native ad was loaded
     */
    fun onNativeLoaded()

    /**
     * Called when native ad is fail to load.
     * But if auto cache enabled for native ads, loading will be continued.
     */
    fun onNativeFailedToLoad()

    /**
     * Called when native ad was shown.
     *
     * @param nativeAd reference of the [com.appodeal.ads.NativeAd] object.
     */
    fun onNativeShown(nativeAd: NativeAd?)

    /**
     * Called when native ad show failed.
     *
     * @param nativeAd reference of the [com.appodeal.ads.NativeAd] object.
     */
    fun onNativeShowFailed(nativeAd: NativeAd?)

    /**
     * Called when native ad was clicked.
     *
     * @param nativeAd reference of the [com.appodeal.ads.NativeAd] object.
     */
    fun onNativeClicked(nativeAd: NativeAd?)

    /**
     * Called when native ad was expired
     */
    fun onNativeExpired()
}
