package com.appodeal.ads.inapp

import com.appodeal.ads.service.ServiceError

/**
 * Callback that returns the result of the in-app purchase validation.
 */
interface InAppPurchaseValidateCallback {

    /**
     * Called when in-app purchase was validated successfully at least one connected service.
     *
     * @param purchase validated purchase.
     * @param errors list of possible errors if the purchase was not validated in at least one
     * of the services. Each error contains the name of the service in which it occurred
     * and a description.
     */
    @JvmSuppressWildcards
    fun onInAppPurchaseValidateSuccess(
        purchase: InAppPurchase,
        errors: List<ServiceError>?
    )

    /**
     * Called when in-app purchase was not validated.
     *
     * @param purchase Invalid purchase.
     * @param errors List of errors that occurred during validation. Each error contains
     * the name of the service in which it occurred and a description.
     */
    @JvmSuppressWildcards
    fun onInAppPurchaseValidateFail(
        purchase: InAppPurchase,
        errors: List<ServiceError>
    )
}
