package com.appodeal.ads.revenue

/**
 * Available revenue precision values
 * @property precisionName - is String name of precision
 */
enum class RevenuePrecision(val precisionName: String) {
    /**
     * Exact revenue precision
     */
    Exact("exact"),

    /**
     * Estimated revenue precision
     */
    Estimated("estimated"),

    /**
     * Undefined revenue precision
     */
    Undefined("undefined"),

    /**
     * Publisher defined revenue precision
     */
    PublisherDefined("publisher_defined")
}
