package com.appodeal.ads.initializing

/**
 * Initialization callback is used to determine Appodeal SDK initialization result
 */
fun interface ApdInitializationCallback {
    /**
     * Called when Appodeal initialization has been finished.
     *
     * If initialization succeeds, [errors] is null. Otherwise, it contains list of errors.
     * @see [ApdInitializationError]
     */
    @JvmSuppressWildcards
    fun onInitializationFinished(errors: List<ApdInitializationError>?)
}
