package com.appodeal.ads.revenue

/**
 * Callback defines a listener to be notified about ad revenue events.
 */
interface AdRevenueCallbacks {
    /**
     * Called every time when SDK receives a revenue information for an ad.
     * @param revenueInfo revenue information for an ad. Guaranteed not to be null.
     */
    fun onAdRevenueReceive(revenueInfo: RevenueInfo)
}
