package com.appodeal.ads.revenue

/**
 * This class represents revenue information.
 */
data class RevenueInfo(
    /**
     * The ad network name. Guaranteed not to be null.
     */
    val networkName: String,
    /**
     * The demand Source name. Bidder name in case of impression from real time bidding
     * or name of ad network. Guaranteed not to be null.
     */
    val demandSource: String,
    /**
     * The Appodeal's ad unit name. Guaranteed not to be null.
     */
    val adUnitName: String,
    /**
     * The Appodeal's placement name. Guaranteed not to be null.
     */
    val placement: String,
    /**
     * The Appodeal's placement id. Guaranteed not to be null.
     */
    val placementId: Int,
    /**
     * The Appodeal's segment id. Guaranteed not to be null.
     */
    val segmentId: Long,
    /**
     * The ad's revenue amount, or 0 if it does not exist.
     */
    val revenue: Double,
    /**
     * The revenue precision.
     * - 'exact' - programmatic revenue is the resulting price of auction
     * - 'publisher_defined' - revenue from crosspromo campaigns
     * - 'estimated' - revenue based on ad network pricefloors or historical eCPM
     * - 'undefined' - revenue amount is not defined
     */
    val revenuePrecision: String,
    /**
     * The Appodeal's ad type. [com.appodeal.ads.Appodeal]
     */
    val adType: Int,
    /**
     * The Appodeal's ad type as string presentation.
     */
    val adTypeString: String,
    /**
     * The revenue platform supported by Appodeal.
     */
    val revenuePlatform: RevenuePlatform,
    /**
     * The payload of the revenue info.
     */
    val payload: Map<String, String> = emptyMap()
) {
    /**
     * The revenue platform supported by Appodeal as string presentation.
     */
    val platform: String = revenuePlatform.stringValue

    /**
     * The current currency supported by Appodeal (USD).
     */
    val revenueCurrency: RevenueCurrency = RevenueCurrency.USD

    /**
     * The current currency supported by Appodeal as string presentation (USD).
     */
    val currency: String = revenueCurrency.stringValue
}
