package com.appodeal.ads

/**
 * Banner's lifecycle interface
 */
interface BannerCallbacks {
    /**
     * Called when banner was loaded
     *
     * @param height     height of the banner (currently 32, 50 or 90 dp)
     * @param isPrecache `true` if banner is precache
     */
    fun onBannerLoaded(height: Int, isPrecache: Boolean)

    /**
     * Called when banner is fail to load.
     * But if auto cache enabled for banners, loading will be continued.
     */
    fun onBannerFailedToLoad()

    /**
     * Called when banner was shown.
     */
    fun onBannerShown()

    /**
     * Called when banner show fail
     */
    fun onBannerShowFailed()

    /**
     * Called when banner was clicked.
     */
    fun onBannerClicked()

    /**
     * Called when banner was expired by time.
     */
    fun onBannerExpired()
}
