package com.appodeal.ads

/**
 * Interstitial's lifecycle interface
 */
interface InterstitialCallbacks {
    /**
     * Called when interstitial was loaded
     * @param isPrecache `true` if interstitial is precache
     */
    fun onInterstitialLoaded(isPrecache: Boolean)

    /**
     * Called when interstitial is fail to load.
     * But if auto cache enabled for interstitials, loading will be continued.
     */
    fun onInterstitialFailedToLoad()

    /**
     * Called when interstitial was shown.
     */
    fun onInterstitialShown()

    /**
     * Called when interstitial show failed
     */
    fun onInterstitialShowFailed()

    /**
     * Called when interstitial was clicked.
     */
    fun onInterstitialClicked()

    /**
     * Called when interstitial was closed.
     */
    fun onInterstitialClosed()

    /**
     * Called when interstitial was expired by time.
     */
    fun onInterstitialExpired()
}
