package com.appodeal.ads

/**
 * MREC's lifecycle interface
 */
interface MrecCallbacks {
    /**
     * Called when MREC was loaded
     *
     * @param isPrecache `true` if MREC is precache
     */
    fun onMrecLoaded(isPrecache: Boolean)

    /**
     * Called when MREC is fail to load.
     * But if auto cache enabled for MRECs, loading will be continued.
     */
    fun onMrecFailedToLoad()

    /**
     * Called when MREC was shown.
     */
    fun onMrecShown()

    /**
     * Called when MREC show failed
     */
    fun onMrecShowFailed()

    /**
     * Called when MREC was clicked.
     */
    fun onMrecClicked()

    /**
     * Called when MREC was expired by time.
     */
    fun onMrecExpired()
}
