package com.appodeal.ads

/**
 * Rewarded video's lifecycle interface
 */
interface RewardedVideoCallbacks {
    /**
     * Called when rewarded video was loaded
     *
     * @param isPrecache `true` if video is precache
     */
    fun onRewardedVideoLoaded(isPrecache: Boolean)

    /**
     * Called when rewarded video is fail to load.
     * But if auto cache enabled for rewarded videos, loading will be continued.
     */
    fun onRewardedVideoFailedToLoad()

    /**
     * Called when rewarded video was shown.
     */
    fun onRewardedVideoShown()

    /**
     * Called when rewarded video show failed.
     */
    fun onRewardedVideoShowFailed()

    /**
     * Called when rewarded video was finished.
     *
     * @param amount amount of reward
     * @param currency   name of currency
     */
    fun onRewardedVideoFinished(amount: Double, currency: String)

    /**
     * Called when rewarded video was closed.
     *
     * @param finished `true` if video was finished
     */
    fun onRewardedVideoClosed(finished: Boolean)

    /**
     * Called when rewarded video was expired by time.
     */
    fun onRewardedVideoExpired()

    /**
     * Called when rewarded video was clicked.
     */
    fun onRewardedVideoClicked()
}
