/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mm.opensdk.openapi;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.util.Log;
import com.tencent.mm.opensdk.b.c;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class MMSharedPreferences
implements SharedPreferences {
    private static final String TAG = "MicroMsg.SDK.SharedPreferences";
    private final ContentResolver cr;
    private final String[] columns = new String[]{"_id", "key", "type", "value"};
    private final HashMap<String, Object> values = new HashMap();
    private REditor editor = null;

    public MMSharedPreferences(Context context) {
        this.cr = context.getContentResolver();
    }

    private Object getValue(String string) {
        try {
            string = this.cr.query(c.b.CONTENT_URI, this.columns, "key = ?", new String[]{string}, null);
            if (string == null) {
                return null;
            }
            int n2 = string.getColumnIndex("type");
            int n3 = string.getColumnIndex("value");
            Object object = null;
            if (string.moveToFirst()) {
                object = c.a.a(string.getInt(n2), string.getString(n3));
            }
            string.close();
            return object;
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)("getValue exception:" + exception.getMessage()));
            return null;
        }
    }

    public Map<String, ?> getAll() {
        try {
            Cursor cursor = this.cr.query(c.b.CONTENT_URI, this.columns, null, null, null);
            if (cursor == null) {
                return null;
            }
            int n2 = cursor.getColumnIndex("key");
            int n3 = cursor.getColumnIndex("type");
            int n4 = cursor.getColumnIndex("value");
            while (cursor.moveToNext()) {
                Object object = c.a.a(cursor.getInt(n3), cursor.getString(n4));
                this.values.put(cursor.getString(n2), object);
            }
            cursor.close();
            return this.values;
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)("getAll exception:" + exception.getMessage()));
            return this.values;
        }
    }

    public String getString(String object, String string) {
        if ((object = this.getValue((String)object)) != null && object instanceof String) {
            return (String)object;
        }
        return string;
    }

    public int getInt(String object, int n2) {
        if ((object = this.getValue((String)object)) != null && object instanceof Integer) {
            return (Integer)object;
        }
        return n2;
    }

    public long getLong(String object, long l2) {
        if ((object = this.getValue((String)object)) != null && object instanceof Long) {
            return (Long)object;
        }
        return l2;
    }

    public float getFloat(String object, float f2) {
        if ((object = this.getValue((String)object)) != null && object instanceof Float) {
            return ((Float)object).floatValue();
        }
        return f2;
    }

    public boolean getBoolean(String object, boolean bl) {
        if ((object = this.getValue((String)object)) != null && object instanceof Boolean) {
            return (Boolean)object;
        }
        return bl;
    }

    public boolean contains(String string) {
        return this.getValue(string) != null;
    }

    public SharedPreferences.Editor edit() {
        if (this.editor == null) {
            this.editor = new REditor(this.cr);
        }
        return this.editor;
    }

    public void registerOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener onSharedPreferenceChangeListener) {
    }

    public void unregisterOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener onSharedPreferenceChangeListener) {
    }

    public Set<String> getStringSet(String string, Set<String> set) {
        return null;
    }

    private static class REditor
    implements SharedPreferences.Editor {
        private Map<String, Object> values = new HashMap<String, Object>();
        private Set<String> remove = new HashSet<String>();
        private boolean clear = false;
        private ContentResolver cr;

        public REditor(ContentResolver contentResolver) {
            this.cr = contentResolver;
        }

        public SharedPreferences.Editor putString(String string, String string2) {
            this.values.put(string, string2);
            this.remove.remove(string);
            return this;
        }

        public SharedPreferences.Editor putInt(String string, int n2) {
            this.values.put(string, n2);
            this.remove.remove(string);
            return this;
        }

        public SharedPreferences.Editor putLong(String string, long l2) {
            this.values.put(string, l2);
            this.remove.remove(string);
            return this;
        }

        public SharedPreferences.Editor putFloat(String string, float f2) {
            this.values.put(string, Float.valueOf(f2));
            this.remove.remove(string);
            return this;
        }

        public SharedPreferences.Editor putBoolean(String string, boolean bl) {
            this.values.put(string, bl);
            this.remove.remove(string);
            return this;
        }

        public SharedPreferences.Editor remove(String string) {
            this.remove.add(string);
            return this;
        }

        public SharedPreferences.Editor clear() {
            this.clear = true;
            return this;
        }

        public boolean commit() {
            ContentValues contentValues = new ContentValues();
            if (this.clear) {
                this.cr.delete(c.b.CONTENT_URI, null, null);
                this.clear = false;
            }
            for (String string : this.remove) {
                this.cr.delete(c.b.CONTENT_URI, "key = ?", new String[]{string});
            }
            for (Map.Entry<String, Object> entry : this.values.entrySet()) {
                boolean bl;
                int n2;
                int n3;
                Object object = entry.getValue();
                ContentValues contentValues2 = contentValues;
                Object object2 = object;
                if (object2 == null) {
                    Log.e((String)"MicroMsg.SDK.PluginProvider.Resolver", (String)"unresolve failed, null value");
                    n3 = 0;
                } else if (object2 instanceof Integer) {
                    n3 = 1;
                } else if (object2 instanceof Long) {
                    n3 = 2;
                } else if (object2 instanceof String) {
                    n3 = 3;
                } else if (object2 instanceof Boolean) {
                    n3 = 4;
                } else if (object2 instanceof Float) {
                    n3 = 5;
                } else if (object2 instanceof Double) {
                    n3 = 6;
                } else {
                    Log.e((String)"MicroMsg.SDK.PluginProvider.Resolver", (String)("unresolve failed, unknown type=" + object2.getClass().toString()));
                    n3 = n2 = 0;
                }
                if (n3 == 0) {
                    bl = false;
                } else {
                    contentValues2.put("type", Integer.valueOf(n2));
                    contentValues2.put("value", object.toString());
                    bl = true;
                }
                if (!bl) continue;
                this.cr.update(c.b.CONTENT_URI, contentValues, "key = ?", new String[]{entry.getKey()});
            }
            return true;
        }

        public void apply() {
        }

        public SharedPreferences.Editor putStringSet(String string, Set<String> set) {
            return null;
        }
    }
}

