/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mm.opensdk.modelmsg;

import android.os.Bundle;
import com.tencent.mm.opensdk.modelmsg.WXMediaMessage;
import com.tencent.mm.opensdk.utils.Log;
import java.io.File;

public class WXEmojiObject
implements WXMediaMessage.IMediaObject {
    private static final String TAG = "MicroMsg.SDK.WXEmojiObject";
    private static final int CONTENT_LENGTH_LIMIT = 0xA00000;
    public byte[] emojiData;
    public String emojiPath;

    public WXEmojiObject() {
        this.emojiData = null;
        this.emojiPath = null;
    }

    public WXEmojiObject(byte[] byArray) {
        this.emojiData = byArray;
    }

    public WXEmojiObject(String string) {
        this.emojiPath = string;
    }

    public void setEmojiData(byte[] byArray) {
        this.emojiData = byArray;
    }

    public void setEmojiPath(String string) {
        this.emojiPath = string;
    }

    @Override
    public void serialize(Bundle bundle) {
        bundle.putByteArray("_wxemojiobject_emojiData", this.emojiData);
        bundle.putString("_wxemojiobject_emojiPath", this.emojiPath);
    }

    @Override
    public void unserialize(Bundle bundle) {
        this.emojiData = bundle.getByteArray("_wxemojiobject_emojiData");
        this.emojiPath = bundle.getString("_wxemojiobject_emojiPath");
    }

    @Override
    public int type() {
        return 8;
    }

    @Override
    public boolean checkArgs() {
        if (!(this.emojiData != null && this.emojiData.length != 0 || this.emojiPath != null && this.emojiPath.length() != 0)) {
            Log.e(TAG, "checkArgs fail, both arguments is null");
            return false;
        }
        if (this.emojiData != null && this.emojiData.length > 0xA00000) {
            Log.e(TAG, "checkArgs fail, emojiData is too large");
            return false;
        }
        if (this.emojiPath != null && this.getFileSize(this.emojiPath) > 0xA00000) {
            Log.e(TAG, "checkArgs fail, emojiSize is too large");
            return false;
        }
        return true;
    }

    private int getFileSize(String object) {
        if (object == null || ((String)object).length() == 0) {
            return 0;
        }
        if (!((File)(object = new File((String)object))).exists()) {
            return 0;
        }
        return (int)((File)object).length();
    }
}

