/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mm.opensdk.openapi;

import android.app.Activity;
import android.app.Application;
import android.app.Service;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import com.tencent.mm.opensdk.channel.a.a;
import com.tencent.mm.opensdk.openapi.BaseWXApiImplV10;
import com.tencent.mm.opensdk.openapi.WXApiImplComm;
import com.tencent.mm.opensdk.utils.Log;
import com.tencent.wxop.stat.MtaSDkException;
import com.tencent.wxop.stat.StatConfig;
import com.tencent.wxop.stat.StatReportStrategy;
import com.tencent.wxop.stat.StatService;

final class WXApiImplV10
extends BaseWXApiImplV10 {
    private static ActivityLifecycleCb activityCb = null;

    WXApiImplV10(Context context, String string, boolean bl) {
        super(context, string, bl);
    }

    @Override
    public final boolean registerApp(String object, long l2) {
        if (this.detached) {
            throw new IllegalStateException("registerApp fail, WXMsgImpl has been detached");
        }
        if (!WXApiImplComm.validateAppSignatureForPackage(this.context, "com.tencent.mm", this.checkSignature)) {
            Log.e("MicroMsg.SDK.WXApiImplV10", "register app failed for wechat app signature check failed");
            return false;
        }
        Log.d("MicroMsg.SDK.WXApiImplV10", "registerApp, appId = " + (String)object);
        if (object != null) {
            this.appId = object;
        }
        if (activityCb == null && Build.VERSION.SDK_INT >= 14) {
            if (this.context instanceof Activity) {
                this.initMta(this.context, (String)object);
                activityCb = new ActivityLifecycleCb(this.context);
                ((Activity)this.context).getApplication().registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)activityCb);
            } else if (this.context instanceof Service) {
                this.initMta(this.context, (String)object);
                activityCb = new ActivityLifecycleCb(this.context);
                ((Service)this.context).getApplication().registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)activityCb);
            } else {
                Log.w("MicroMsg.SDK.WXApiImplV10", "context is not instanceof Activity or Service, disable WXStat");
            }
        }
        Log.d("MicroMsg.SDK.WXApiImplV10", "registerApp, appId = " + (String)object);
        if (object != null) {
            this.appId = object;
        }
        Log.d("MicroMsg.SDK.WXApiImplV10", "register app " + this.context.getPackageName());
        object = new a.a();
        new a.a().W = "com.tencent.mm";
        ((a.a)object).action = "com.tencent.mm.plugin.openapi.Intent.ACTION_HANDLE_APP_REGISTER";
        ((a.a)object).content = "weixin://registerapp?appid=" + this.appId;
        ((a.a)object).X = l2;
        return a.a(this.context, (a.a)object);
    }

    @Override
    public final void detach() {
        if (activityCb != null && Build.VERSION.SDK_INT >= 14) {
            if (this.context instanceof Activity) {
                ((Activity)this.context).getApplication().unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)activityCb);
            } else if (this.context instanceof Service) {
                ((Service)this.context).getApplication().unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)activityCb);
            }
            activityCb.detach();
        }
        super.detach();
    }

    private void initMta(Context context, String string) {
        string = "AWXOP" + string;
        StatConfig.setAppKey(context, string);
        StatConfig.setEnableSmartReporting(true);
        StatConfig.setStatSendStrategy(StatReportStrategy.PERIOD);
        StatConfig.setSendPeriodMinutes(60);
        StatConfig.setInstallChannel(context, "Wechat_Sdk");
        try {
            StatService.startStatService(context, string, "2.0.4");
            return;
        }
        catch (MtaSDkException mtaSDkException) {
            Log.e("MicroMsg.SDK.WXApiImplV10", "initMta exception:" + mtaSDkException.getMessage());
            return;
        }
    }

    private static final class ActivityLifecycleCb
    implements Application.ActivityLifecycleCallbacks {
        private static final String TAG = "MicroMsg.SDK.WXApiImplV10.ActivityLifecycleCb";
        private static final int DELAYED = 800;
        private boolean isForeground = false;
        private Handler handler = new Handler(Looper.getMainLooper());
        private Context context;
        private Runnable onPausedRunnable = new Runnable(){

            @Override
            public void run() {
                if (activityCb != null && ActivityLifecycleCb.this.isForeground) {
                    android.util.Log.v((String)ActivityLifecycleCb.TAG, (String)"WXStat trigger onBackground");
                    StatService.trackCustomKVEvent(ActivityLifecycleCb.this.context, "onBackground_WX", null);
                    ActivityLifecycleCb.this.isForeground = false;
                }
            }
        };
        private Runnable onResumedRunnable = new Runnable(){

            @Override
            public void run() {
                if (activityCb != null && !ActivityLifecycleCb.this.isForeground) {
                    android.util.Log.v((String)ActivityLifecycleCb.TAG, (String)"WXStat trigger onForeground");
                    StatService.trackCustomKVEvent(ActivityLifecycleCb.this.context, "onForeground_WX", null);
                    ActivityLifecycleCb.this.isForeground = true;
                }
            }
        };

        private ActivityLifecycleCb(Context context) {
            this.context = context;
        }

        public final void onActivityCreated(Activity activity, Bundle bundle) {
        }

        public final void onActivityDestroyed(Activity activity) {
        }

        public final void onActivityPaused(Activity activity) {
            android.util.Log.v((String)TAG, (String)(activity.getComponentName().getClassName() + "  onActivityPaused"));
            this.handler.removeCallbacks(this.onResumedRunnable);
            this.handler.postDelayed(this.onPausedRunnable, 800L);
        }

        public final void onActivityResumed(Activity activity) {
            android.util.Log.v((String)TAG, (String)(activity.getComponentName().getClassName() + "  onActivityResumed"));
            this.handler.removeCallbacks(this.onPausedRunnable);
            this.handler.postDelayed(this.onResumedRunnable, 800L);
        }

        public final void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        }

        public final void onActivityStarted(Activity activity) {
        }

        public final void onActivityStopped(Activity activity) {
        }

        public final void detach() {
            this.handler.removeCallbacks(this.onResumedRunnable);
            this.handler.removeCallbacks(this.onPausedRunnable);
            this.context = null;
        }
    }
}

