package io.bidmachine.schema.analytics.rendering

import com.github.plokhotnyuk.jsoniter_scala.core.JsonValueCodec
import com.github.plokhotnyuk.jsoniter_scala.macros.{CodecMakerConfig, JsonCodecMaker}

case class RenderingTemplate(
  video: Option[VideoTemplate],
  endcard: Option[EndCardTemplate],
  postbanner: Option[PostbannerTemplate],
  instl: Option[InterstitialTemplate]
)

object RenderingTemplate {
  implicit val renderingDslTemplateCodec: JsonValueCodec[RenderingTemplate] =
    JsonCodecMaker.make[RenderingTemplate](CodecMakerConfig)
}
