package io.bidmachine.schema.adcom

import enumeratum.values.{IntEnum, IntEnumEntry}
import io.bidmachine.schema.jsoniter.JsoniterEnumInstances

sealed abstract class CategoryTaxonomy(val value: Int) extends IntEnumEntry

object CategoryTaxonomy extends IntEnum[CategoryTaxonomy] with JsoniterEnumInstances {

  case object IABContentCategoryTaxonomy1 extends CategoryTaxonomy(1)
  case object IABContentCategoryTaxonomy2 extends CategoryTaxonomy(2)
  case object IABAdProductTaxonomy1       extends CategoryTaxonomy(3)

  val values = findValues
}
