package io.bidmachine.schema.adcom

import enumeratum.values.{IntEnum, IntEnumEntry}
import io.bidmachine.schema.jsoniter.JsoniterEnumInstances

sealed abstract class DisplayPlacementType(val value: Int) extends IntEnumEntry

object DisplayPlacementType extends IntEnum[DisplayPlacementType] with JsoniterEnumInstances {

  case object Feed    extends DisplayPlacementType(1)
  case object Unit    extends DisplayPlacementType(2)
  case object Outside extends DisplayPlacementType(3)
  case object Widget  extends DisplayPlacementType(4)

  val values = findValues
}
