package io.bidmachine.schema.rtb

import com.github.plokhotnyuk.jsoniter_scala.core.JsonValueCodec
import com.github.plokhotnyuk.jsoniter_scala.macros.{CodecMakerConfig, JsonCodecMaker}
import io.bidmachine.schema.adcom.Ad
import io.bidmachine.schema.annotations.money

import java.time.Instant

case class AdCachedBid(
  id: Option[String],
  @money price: Double,
  bidid: Option[String], // BidResponse ID
  timestamp: Instant,
  ttl: String,
  media: Ad
)

object AdCachedBid {

  implicit val adCachedBidCodec: JsonValueCodec[AdCachedBid] = JsonCodecMaker.make[AdCachedBid](CodecMakerConfig)
}
