package io.bidmachine.schema.analytics

import com.github.plokhotnyuk.jsoniter_scala.core.JsonValueCodec
import com.github.plokhotnyuk.jsoniter_scala.macros.{CodecMakerConfig, JsonCodecMaker}
import io.bidmachine.schema.analytics.meta.EventMeta
import io.bidmachine.schema.rtb.{Bid, Request}

import java.time.Instant

case class AdRequestEvent(
  timestamp: Instant,
  meta: EventMeta,
  buyer: Option[Buyer],
  seller: Seller,
  request: Request,
  bid: Option[Bid]
)

object AdRequestEvent {
  implicit val adRequestCodec: JsonValueCodec[AdRequestEvent] = JsonCodecMaker.make[AdRequestEvent](CodecMakerConfig)
}
