package io.bidmachine.schema.adcom

import enumeratum.values.{IntEnum, IntEnumEntry}
import io.bidmachine.schema.jsoniter.JsoniterEnumInstances

sealed abstract class SizeUnit(val value: Int) extends IntEnumEntry

object SizeUnit extends IntEnum[SizeUnit] with JsoniterEnumInstances {

  case object DIP extends SizeUnit(1)
  case object In  extends SizeUnit(2)
  case object Cm  extends SizeUnit(3)

  val values = findValues
}
