package io.bidmachine.schema.analytics.rendering

import com.github.plokhotnyuk.jsoniter_scala.core.JsonValueCodec
import com.github.plokhotnyuk.jsoniter_scala.macros.{CodecMakerConfig, JsonCodecMaker}

case class VideoTemplate(
  videoClickable: Option[Boolean],
  countdown: Option[CountdownTemplate],
  closableView: Option[ClosableViewTemplate],
  mute: Option[MuteTemplate],
  unmute: Option[UnmuteTemplate],
  closeTime: Option[Double],
  r1: Option[Boolean],
  r2: Option[Boolean],
  cta: Option[CTATemplate],
  animationElement: Option[AnimationElementTemplate],
  autoskip: Option[Boolean]
)

object VideoTemplate {
  implicit val videoTemplateCodec: JsonValueCodec[VideoTemplate] = JsonCodecMaker.make[VideoTemplate](CodecMakerConfig)
}
