package io.bidmachine.schema.analytics.meta

import enumeratum.values.{IntEnum, IntEnumEntry}
import io.bidmachine.schema.jsoniter.JsoniterEnumInstances

sealed abstract class SamplingBias(val value: Int) extends IntEnumEntry

object SamplingBias extends IntEnum[SamplingBias] with JsoniterEnumInstances {

  case object Unbiased extends SamplingBias(0)
  case object User     extends SamplingBias(1)
  case object BmUser   extends SamplingBias(2)

  val values = findValues
}
