package io.bidmachine.schema.adcom

import enumeratum.values.{IntEnum, IntEnumEntry}
import io.bidmachine.schema.jsoniter.JsoniterEnumInstances

sealed abstract class ApiFramework(val value: Int) extends IntEnumEntry

object ApiFramework extends IntEnum[ApiFramework] with JsoniterEnumInstances {

  case object VPAID_1 extends ApiFramework(1)
  case object VPAID_2 extends ApiFramework(2)
  case object MRAID_1 extends ApiFramework(3)
  case object ORMMA   extends ApiFramework(4)
  case object MRAID_2 extends ApiFramework(5)
  case object MRAID_3 extends ApiFramework(6)
  case object OMID_1  extends ApiFramework(7)
  case object SIMID_1 extends ApiFramework(8)

  val values = findValues
}
