package io.bidmachine.schema.adcom

import com.github.plokhotnyuk.jsoniter_scala.core.JsonValueCodec
import com.github.plokhotnyuk.jsoniter_scala.macros.{CodecMakerConfig, JsonCodecMaker}

/**
 * @param timezone
 *   The time zone associated with location, as specified by the <a href="https://www.iana.org/time-zones">IANA Time
 *   Zone Database</a>, e.g., "Europe/Warsaw".
 */
case class Geo(
  `type`: Option[LocationType],
  lat: Option[Double],
  lon: Option[Double],
  accur: Option[Int],
  lastfix: Option[Int],
  ipserv: Option[LocationService],
  country: Option[CountryCode],
  region: Option[String],
  metro: Option[String],
  city: Option[String],
  zip: Option[String],
  utcoffset: Option[Int],
  timezone: Option[String]
)

object Geo {
  implicit val geoCodec: JsonValueCodec[Geo] = JsonCodecMaker.make[Geo](CodecMakerConfig)
}
