package io.bidmachine.schema.adcom

import enumeratum.values.{IntEnum, IntEnumEntry}
import io.bidmachine.schema.jsoniter.JsoniterEnumInstances

sealed abstract class LocationService(val value: Int) extends IntEnumEntry

object LocationService extends IntEnum[LocationService] with JsoniterEnumInstances {

  case object IP2Location extends LocationService(1)
  case object Neustar     extends LocationService(2)
  case object MaxMind     extends LocationService(3)
  case object NetAcuity   extends LocationService(4)
  case object Unknown     extends LocationService(500)
  case object Sypex       extends LocationService(501)

  val values = findValues
}
