package io.bidmachine.schema.adcom

import com.github.plokhotnyuk.jsoniter_scala.core.JsonValueCodec
import com.github.plokhotnyuk.jsoniter_scala.macros.{CodecMakerConfig, JsonCodecMaker}

case class Restrictions(
  cattax: Option[CategoryTaxonomy],
  bcat: List[String],
  badv: List[String],
  bapp: List[String],
  battr: List[CreativeAttribute]
)

object Restrictions {
  implicit val restrictionsCodec: JsonValueCodec[Restrictions] = JsonCodecMaker.make[Restrictions](CodecMakerConfig)
}
