package io.bidmachine.schema.analytics

import com.github.plokhotnyuk.jsoniter_scala.core.JsonValueCodec
import com.github.plokhotnyuk.jsoniter_scala.macros.{CodecMakerConfig, JsonCodecMaker}

case class IvtDetectionResult(
  // whether request is considered IVT
  isIVT: Boolean,
  // lookup identifier from Media Guard
  lookupId: String,
  // List of ivt reason codes
  ivtTaxonomy: List[String]
)

object IvtDetectionResult {
  implicit val ivtDetectionResultCodec: JsonValueCodec[IvtDetectionResult] =
    JsonCodecMaker.make[IvtDetectionResult](CodecMakerConfig)
}
