package io.bidmachine.schema.analytics

import com.github.plokhotnyuk.jsoniter_scala.core.JsonValueCodec
import com.github.plokhotnyuk.jsoniter_scala.macros.{CodecMakerConfig, JsonCodecMaker}

import java.time.Instant

final case class CreativeEvent(timestamp: Instant, creative: Creative)

object CreativeEvent {
  implicit val creativeEventCodec: JsonValueCodec[CreativeEvent] = JsonCodecMaker.make[CreativeEvent](CodecMakerConfig)
}
