package io.bidmachine.schema.adcom

import com.github.plokhotnyuk.jsoniter_scala.core.JsonValueCodec
import com.github.plokhotnyuk.jsoniter_scala.macros.{CodecMakerConfig, JsonCodecMaker}
import enumeratum.values.{IntEnum, IntEnumEntry}
import io.bidmachine.schema.jsoniter.JsoniterEnumInstances.jsoniterIntEnumCodec

case class Ad(
  id: Option[String],
  adomain: List[String],
  bundle: Option[String],
  iurl: Option[String],
  cat: List[String],
  cattax: Option[CategoryTaxonomy],
  lang: Option[String],
  attr: List[CreativeAttribute],
  secure: Option[Boolean],
  mrating: Option[MediaRating],
  ext: Ad.Ext
)

object Ad {
  object Ext {
    sealed abstract class DeepLink(val value: Int) extends IntEnumEntry

    object DeepLink extends IntEnum[DeepLink] {

      case object None          extends DeepLink(0)
      case object Web           extends DeepLink(1)
      case object Sdk           extends DeepLink(2)
      case object InlineInstall extends DeepLink(3)

      val values = findValues
    }

    sealed abstract class VastAdType(override val value: Int) extends IntEnumEntry

    object VastAdType extends IntEnum[VastAdType] {

      case object Undefined extends VastAdType(0)
      case object Inline    extends VastAdType(1)
      case object Wrapper   extends VastAdType(2)
      case object Multiple  extends VastAdType(3)

      val values = findValues
    }

    sealed abstract class VastCompanionType(override val value: Int) extends IntEnumEntry

    object VastCompanionType extends IntEnum[VastCompanionType] {

      case object Undefined extends VastCompanionType(0)
      case object Iframe    extends VastCompanionType(1)
      case object Static    extends VastCompanionType(2)
      case object Html      extends VastCompanionType(3)
      case object Multiple  extends VastCompanionType(4)

      val values = findValues
    }
  }

  case class Ext(
    cid: Option[String],
    deepLink: Ext.DeepLink = Ext.DeepLink.None,
    vastAdType: Ext.VastAdType = Ext.VastAdType.Undefined,
    vastCompanionType: Ext.VastCompanionType = Ext.VastCompanionType.Undefined
  )

  implicit val deepLinkCodec: JsonValueCodec[Ext.DeepLink]                   = jsoniterIntEnumCodec
  implicit val vastAdTypeCodec: JsonValueCodec[Ext.VastAdType]               = jsoniterIntEnumCodec
  implicit val vastCompanionTypeCodec: JsonValueCodec[Ext.VastCompanionType] = jsoniterIntEnumCodec
  implicit val adExtCodec: JsonValueCodec[Ext]                               = JsonCodecMaker.make[Ext](CodecMakerConfig)
  implicit val adCodec: JsonValueCodec[Ad]                                   = JsonCodecMaker.make[Ad](CodecMakerConfig)

}
