package io.bidmachine.schema.adcom

import enumeratum.values.{IntEnum, IntEnumEntry}
import io.bidmachine.schema.jsoniter.JsoniterEnumInstances

sealed abstract class ClickType(val value: Int) extends IntEnumEntry

object ClickType extends IntEnum[ClickType] with JsoniterEnumInstances {

  case object NonClickable             extends ClickType(0)
  case object ClickableUnknown         extends ClickType(1)
  case object ClickableEmbeddedBrowser extends ClickType(2)
  case object ClickableNativeBrowser   extends ClickType(3)

  val values = findValues
}
