package io.bidmachine.schema.analytics

import enumeratum.values.{StringEnum, StringEnumEntry}
import io.bidmachine.schema.jsoniter.JsoniterEnumInstances

sealed abstract class ReviewReason(val value: String) extends StringEnumEntry

object ReviewReason extends StringEnum[ReviewReason] with JsoniterEnumInstances {

  case object Active    extends ReviewReason("active")
  case object Defected  extends ReviewReason("defected")
  case object Violating extends ReviewReason("violating")

  def values = findValues
}
