package io.bidmachine.schema.analytics

import com.github.plokhotnyuk.jsoniter_scala.core.JsonValueCodec
import com.github.plokhotnyuk.jsoniter_scala.macros.{CodecMakerConfig, JsonCodecMaker}

import java.time.Instant

case class AdRequestAppTracking(
  timestamp: Instant,
  bundle: Option[String],
  idfv: Option[String],
  idfa: Option[String],
  os: Option[String],
  osv: Option[String],
  model: Option[String],
  make: Option[String],
  ip: Option[String],
  country: Option[String]
)
object AdRequestAppTracking {
  implicit val adRequestCodec: JsonValueCodec[AdRequestAppTracking] =
    JsonCodecMaker.make[AdRequestAppTracking](CodecMakerConfig)
}
