package io.bidmachine.schema.analytics

import com.github.plokhotnyuk.jsoniter_scala.core.JsonValueCodec
import com.github.plokhotnyuk.jsoniter_scala.macros.{CodecMakerConfig, JsonCodecMaker}
import io.bidmachine.schema.adcom.CountryCode

case class BIAdRequestEvent(
  t: Long,                 // timestamp
  b: Option[String],       // bundle
  c: Option[CountryCode],  // country
  a: Long,                 // ad type
  ifa: Option[String],
  ifv: Option[String],
  s: Long,                 // source id
  o: Long,                 // device os
  f: Option[List[Double]], // floors
  m: Option[Long],         // mediationStackId
  v: Option[String],       // bm sdk version
  p: Option[Long],         // postbid flag; 1 = true, 0 or none/null = false,
  dc: Byte = 0
)

object BIAdRequestEvent {

  def adTypeFrom(string: String): Int = string match {
    case "banner"                     => 1
    case "interstitial"               => 2
    case "skippable_video"            => 3
    case "non_skippable_video"        => 4
    case "mrec"                       => 5
    case "native"                     => 6
    case "non_skippable_interstitial" => 7
    case _                            => 0
  }

  def osFrom(string: Option[String]): Int = string.map(_.toLowerCase) match {
    case Some("ios")     => 1
    case Some("android") => 2
    case _               => 0
  }

  def bmSDKVersionFrom(sdk: Option[String], sdkVersion: Option[String]): Option[String] =
    sdkVersion.filter(_ => sdk.exists(str => str == "BidMachine" || str == "BidMachine SDK"))

  def dcFrom(dc: String): Byte = (dc.toUpperCase match {
    case "US"     => 1
    case "US-WAS" => 2
    case "EU-AMS" => 3
    case "APAC"   => 4
    case _        => 0
  }).toByte

  implicit val bIAdRequestCodec: JsonValueCodec[BIAdRequestEvent] =
    JsonCodecMaker.make[BIAdRequestEvent](CodecMakerConfig)

}
