package io.bidmachine.schema.analytics.meta

import enumeratum.values.{IntEnum, IntEnumEntry}
import io.bidmachine.schema.jsoniter.JsoniterEnumInstances

sealed abstract class SamplingMethod(val value: Int) extends IntEnumEntry

object SamplingMethod extends IntEnum[SamplingMethod] with JsoniterEnumInstances {

  case object SimpleRandom extends SamplingMethod(0)
  case object MurmurHash3  extends SamplingMethod(1)

  val values = findValues
}
