package io.bidmachine.schema.analytics.sdkerrorevent

import com.github.plokhotnyuk.jsoniter_scala.core.JsonValueCodec
import com.github.plokhotnyuk.jsoniter_scala.macros.{CodecMakerConfig, JsonCodecMaker}
import io.bidmachine.schema.analytics.meta.EventMeta
import io.bidmachine.schema.analytics.{Buyer, Seller}
import io.bidmachine.schema.rtb.{Bid, Request}

import java.time.Instant

case class SDKErrorEvent(
  timestamp: Instant,
  eventCode: Int,
  network: Option[String],
  adType: Option[String],
  price: Double,
  latencyLevel: String,
  extPlacementId: Option[Long],
  sessionInterval: Option[Long],
  sessionIntervalLevel: Option[String],
  error: Option[SDKEventError],
  meta: EventMeta,
  buyer: Buyer,
  seller: Seller,
  request: Request,
  bid: Bid
)

object SDKErrorEvent {
  implicit val sdkEventCodec: JsonValueCodec[SDKErrorEvent] = JsonCodecMaker.make[SDKErrorEvent](CodecMakerConfig)
}
