package io.bidmachine.schema.adcom

import com.github.plokhotnyuk.jsoniter_scala.core.JsonValueCodec
import com.github.plokhotnyuk.jsoniter_scala.macros.{CodecMakerConfig, JsonCodecMaker}

case class Placement(
  tagid: Option[String],
  ssai: Option[Int],
  sdk: Option[String],
  sdkver: Option[String],
  reward: Option[Boolean],
  secure: Option[Boolean],
  display: Option[DisplayPlacement],
  video: Option[VideoPlacement]
)

object Placement {
  implicit val placementCodec: JsonValueCodec[Placement] = JsonCodecMaker.make[Placement](CodecMakerConfig)
}
