package io.bidmachine.schema.analytics

import com.github.plokhotnyuk.jsoniter_scala.core.JsonValueCodec
import com.github.plokhotnyuk.jsoniter_scala.macros.{CodecMakerConfig, JsonCodecMaker}

final case class Creative(
  id: Option[Long],
  cid: Option[String],
  crid: Option[String],
  adDomain: Option[String],
  adCategory: Option[String],
  agencyId: Option[Long],
  agencyName: Option[String],
  iURL: Option[String],
  hash: String,
  adm: Option[String],
  imageURL: Option[String],
  admURL: String,
  reviewReason: ReviewReason,
  sellerId: Long,
  sourceId: Long,
  bundle: Option[String],
  categories: Option[String]
)

object Creative {
  implicit val creativeCodec: JsonValueCodec[Creative] = JsonCodecMaker.make[Creative](CodecMakerConfig)
}
