package io.bidmachine.schema.adcom

import enumeratum.values.{IntEnum, IntEnumEntry}
import io.bidmachine.schema.jsoniter.JsoniterEnumInstances

sealed abstract class DisplayContextType(val value: Int) extends IntEnumEntry

object DisplayContextType extends IntEnum[DisplayContextType] with JsoniterEnumInstances {

  case object Content              extends DisplayContextType(10)
  case object ContentArticle       extends DisplayContextType(11)
  case object ContentVideo         extends DisplayContextType(12)
  case object ContentAudio         extends DisplayContextType(13)
  case object ContentImage         extends DisplayContextType(14)
  case object ContentUserGenerated extends DisplayContextType(15)
  case object Social               extends DisplayContextType(20)
  case object SocialEmail          extends DisplayContextType(21)
  case object SocialChat           extends DisplayContextType(22)
  case object Product              extends DisplayContextType(30)
  case object ProductApp           extends DisplayContextType(31)
  case object ProductReview        extends DisplayContextType(32)

  val values = findValues
}
