package io.bidmachine.schema.analytics.rendering

import com.github.plokhotnyuk.jsoniter_scala.core.JsonValueCodec
import com.github.plokhotnyuk.jsoniter_scala.macros.{CodecMakerConfig, JsonCodecMaker}

case class EndCardTemplate(
  closeTime: Option[Double],
  countdown: Option[CountdownTemplate],
  closableView: Option[ClosableViewTemplate],
  animationElement: Option[AnimationElementTemplate],
  autoskip: Option[Boolean],
  r1: Option[Boolean]
)

object EndCardTemplate {
  implicit val endCardTemplateCodec: JsonValueCodec[EndCardTemplate] =
    JsonCodecMaker.make[EndCardTemplate](CodecMakerConfig)
}
