package io.bidmachine.schema.adcom

import enumeratum.values.{IntEnum, IntEnumEntry}
import io.bidmachine.schema.jsoniter.JsoniterEnumInstances

sealed abstract class CreativeAttribute(val value: Int) extends IntEnumEntry

object CreativeAttribute extends IntEnum[CreativeAttribute] with JsoniterEnumInstances {

  case object AudioAuto              extends CreativeAttribute(1)
  case object AudioUser              extends CreativeAttribute(2)
  case object ExpandableAuto         extends CreativeAttribute(3)
  case object ExpandableUserClick    extends CreativeAttribute(4)
  case object ExpandableUserRollover extends CreativeAttribute(5)
  case object VideoAuto              extends CreativeAttribute(6)
  case object VideoUser              extends CreativeAttribute(7)
  case object Pop                    extends CreativeAttribute(8)
  case object Provocative            extends CreativeAttribute(9)
  case object ExtremeAnimation       extends CreativeAttribute(10)
  case object Surveys                extends CreativeAttribute(11)
  case object TextOnly               extends CreativeAttribute(12)
  case object Interactive            extends CreativeAttribute(13)
  case object WindowsDialog          extends CreativeAttribute(14)
  case object HasAudioToggleButton   extends CreativeAttribute(15)
  case object HasSkipButton          extends CreativeAttribute(16)
  case object EpilepsyWarning        extends CreativeAttribute(17)
  case object Responsive             extends CreativeAttribute(18)

  val values = findValues
}
