package io.bidmachine.schema.rtb

import com.github.plokhotnyuk.jsoniter_scala.core.JsonValueCodec
import com.github.plokhotnyuk.jsoniter_scala.macros.{CodecMakerConfig, JsonCodecMaker}
import io.bidmachine.schema.adcom.CountryCode

case class AdCachedRequest(
  id: String,
  bundle: Option[String],
  ifa: Option[String],
  country: Option[CountryCode],
  adt: String, // Ad Type
  dc: String,  // Datacenter ID
  sellerFlr: Double,
  flr: Double,
  sessionId: Option[String],
  bmIfv: Option[String],
  adRequestId: String
)

object AdCachedRequest {
  import io.bidmachine.schema.adcom.Geo._

  implicit val adCachedRequestCodec: JsonValueCodec[AdCachedRequest] =
    JsonCodecMaker.make[AdCachedRequest](CodecMakerConfig)
}
