package io.bidmachine.schema.analytics

import com.github.plokhotnyuk.jsoniter_scala.core.JsonValueCodec
import com.github.plokhotnyuk.jsoniter_scala.macros.{CodecMakerConfig, JsonCodecMaker}

case class Seller(
  id: Long,
  sourceId: Long,
  chargeSchema: String,
  salesRepresentativeId: Option[Long],
  accountManagerId: Option[Long]
)

object Seller {
  implicit val sellerCodec: JsonValueCodec[Seller] = JsonCodecMaker.make[Seller](CodecMakerConfig)
}
